/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.IPCEventLTV;
import apicore.message.KeepAliveLTV;
import apicore.message.LTV;
import apicore.message.LTVFactory;
import apicore.ptmp.AuthenticationTask;
import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.ConnectionNegotiationTask;
import apicore.ptmp.DisconnectTask;
import apicore.ptmp.EventManager;
import apicore.ptmp.KeepAliveTask;
import apicore.ptmp.PTSessionClosedError;
import apicore.ptmp.PacketTracerConnection;
import apicore.ptmp.PacketTracerReadWorker;
import apicore.ptmp.Pipeline;
import apicore.ptmp.SimpleEventManager;
import apicore.util.Logger;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class PacketTracerSession {
    protected PacketTracerConnection packetTracerConnection;
    protected Pipeline pipeline;
    protected PacketTracerReadWorker readWorker;
    protected EventManager eventManager;
    protected LTVFactory ltvFactory;
    protected Timer timer;
    protected long sessionID;
    protected boolean isShutdown = false;
    protected int readErrorCount = 0;

    protected PacketTracerSession() {
    }

    public PacketTracerSession(String string, int n, ConnectionNegotiationProperties connectionNegotiationProperties) throws Exception {
        this.sessionID = System.nanoTime();
        this.ltvFactory = new LTVFactory();
        this.eventManager = new SimpleEventManager(this);
        this.packetTracerConnection = new PacketTracerConnection(string, n, connectionNegotiationProperties);
        this.packetTracerConnection.connect();
        ConnectionNegotiationTask connectionNegotiationTask = new ConnectionNegotiationTask(this.packetTracerConnection);
        connectionNegotiationTask.negotiateConnection();
        this.packetTracerConnection.connectLowLevelReadThread();
        this.pipeline = new Pipeline(this.ltvFactory, this.packetTracerConnection);
        AuthenticationTask authenticationTask = new AuthenticationTask(this);
        boolean bl = authenticationTask.authenticate();
        if (bl) {
            this.timer = new Timer(Long.toString(this.sessionID));
            KeepAliveTask keepAliveTask = new KeepAliveTask(this);
            this.timer.schedule((TimerTask)keepAliveTask, KeepAliveTask.KEEP_ALIVE_INTERVAL, (long)KeepAliveTask.KEEP_ALIVE_INTERVAL);
            this.readWorker = new PacketTracerReadWorker(this, this.pipeline);
            this.readWorker.start();
            this.eventManager.start();
        } else {
            if (Logger.isWarnEnabled()) {
                Logger.warn("Authentication failed.");
                Logger.warn("Attempting to disconnecting from Packet Tracer.");
            }
            this.close();
        }
    }

    public void close() throws IOException {
        if (this.eventManager != null) {
            this.eventManager.shouldStop();
        }
        if (this.readWorker != null) {
            this.readWorker.shouldStop();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        DisconnectTask disconnectTask = new DisconnectTask(this);
        disconnectTask.disconnect();
        this.isShutdown = true;
    }

    protected void emergencyShutdown() {
        block6: {
            try {
                this.isShutdown = true;
                if (this.eventManager != null) {
                    this.eventManager.shouldStop();
                }
                if (this.readWorker != null) {
                    this.readWorker.shouldStop();
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.packetTracerConnection != null) {
                    this.packetTracerConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)throwable;
            }
        }
    }

    public boolean readWorkerError(Throwable throwable) {
        ++this.readErrorCount;
        boolean bl = false;
        try {
            bl = this.packetTracerConnection.isOpen();
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            bl = false;
        }
        if (!bl || this.readErrorCount > 10) {
            this.readWorker.shouldStop();
            this.emergencyShutdown();
            return false;
        }
        return true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        if (this.eventManager != null) {
            this.eventManager.shouldStop();
            this.eventManager = null;
        }
        this.eventManager = eventManager;
        this.eventManager.start();
    }

    public PacketTracerConnection connection() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.packetTracerConnection;
    }

    public Pipeline pipeline() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.pipeline;
    }

    public PacketTracerReadWorker readWorker() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.readWorker;
    }

    public Timer timer() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.timer;
    }

    public boolean isConnected() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.packetTracerConnection.isConnected();
    }

    public boolean isOpen() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.packetTracerConnection.isOpen();
    }

    public boolean isUp() {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        return this.packetTracerConnection.isUp();
    }

    public void testWrite() throws IOException {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        this.write(new KeepAliveLTV());
    }

    public void write(LTV lTV) throws IOException {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        this.pipeline.write(lTV);
    }

    public LTV writeRead(LTV lTV) throws Exception {
        if (this.isShutdown) {
            throw new PTSessionClosedError("PacketTracerSession is shut down");
        }
        if (lTV.hasResponse()) {
            if (this.readWorker == null) {
                throw new Error("Attempt to send an LTV with asynchronous response before readWorker initialized; LTV = " + lTV);
            }
            this.readWorker.registerRequest(lTV);
            this.pipeline.write(lTV);
            return this.readWorker.getResponse(lTV);
        }
        if (this.readWorker != null) {
            throw new Error("Attempt to send an LTV with a blocking response after readWorker initialized; LTV = " + lTV);
        }
        this.pipeline.write(lTV);
        return this.pipeline.read();
    }

    public void handleEvent(IPCEventLTV iPCEventLTV) {
        if (this.eventManager != null) {
            this.eventManager.processEvent(iPCEventLTV);
        }
    }

    public void handleMuMessage(LTV lTV) {
    }
}

